/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.client.screen.handler;

import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import de.cristelknight.doapi.client.recipebook.handler.AbstractRecipeBookGUIScreenHandler;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.satisfyu.meadow.client.recipebook.group.CookingCauldronRecipeBookGroup;
import net.satisfyu.meadow.recipes.cooking.CookingCauldronRecipe;
import net.satisfyu.meadow.registry.RecipeRegistry;
import net.satisfyu.meadow.registry.ScreenHandlerRegistry;

public class CookingCauldronGuiHandler
extends AbstractRecipeBookGUIScreenHandler {
    public CookingCauldronGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(7), (ContainerData)new SimpleContainerData(2));
    }

    public CookingCauldronGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerRegistry.COOKING_CAULDRON_SCREEN_HANDLER.get(), syncId, 6, playerInventory, inventory, propertyDelegate);
        this.buildBlockEntityContainer(playerInventory, inventory);
        this.buildPlayerContainer(playerInventory);
    }

    private void buildBlockEntityContainer(Inventory playerInventory, Container inventory) {
        this.m_38897_((Slot)new FurnaceResultSlot(playerInventory.f_35978_, inventory, 0, 124, 26));
        for (int row = 0; row < 2; ++row) {
            for (int slot = 0; slot < 3; ++slot) {
                this.m_38897_(new Slot(inventory, 1 + slot + row + row * 2, 30 + slot * 18, 17 + row * 18));
            }
        }
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.m_6413_(1) != 0;
    }

    private boolean isItemIngredient(ItemStack stack) {
        return this.recipeStream().anyMatch(cookingPotRecipe -> cookingPotRecipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(stack)));
    }

    private Stream<CookingCauldronRecipe> recipeStream() {
        return this.world.m_7465_().m_44013_((RecipeType)RecipeRegistry.COOKING.get()).stream();
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = 600;
        if (progress == 0) {
            return 0;
        }
        return progress * arrowWidth / 600 + 1;
    }

    public List<IRecipeBookGroup> getGroups() {
        return CookingCauldronRecipeBookGroup.CAULDRON_GROUPS;
    }

    public boolean hasIngredient(Recipe<?> recipe) {
        if (recipe instanceof CookingCauldronRecipe) {
            CookingCauldronRecipe potRecipe = (CookingCauldronRecipe)recipe;
            for (Ingredient ingredient : potRecipe.m_7527_()) {
                boolean found = false;
                for (Slot slot : this.f_38839_) {
                    if (!ingredient.test(slot.m_7993_())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getCraftingSlotCount() {
        return 6;
    }
}

